/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class ThreeLogicTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    private final int[] logicTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Logic").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_LOGIC, (GenericTileEntity)this)).shortListener(Sync.integer(() -> this.logicTable[0], v -> {
        this.logicTable[0] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[1], v -> {
        this.logicTable[1] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[2], v -> {
        this.logicTable[2] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[3], v -> {
        this.logicTable[3] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[4], v -> {
        this.logicTable[4] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[5], v -> {
        this.logicTable[5] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[6], v -> {
        this.logicTable[6] = v;
    })).shortListener(Sync.integer(() -> this.logicTable[7], v -> {
        this.logicTable[7] = v;
    })).setupSync((GenericTileEntity)this));
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<Integer> PARAM_STATE = new Key("state", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETSTATE = Command.create((String)"logic.setState", (te, player, params) -> {
        te.logicTable[((Integer)params.get(ThreeLogicTileEntity.PARAM_INDEX)).intValue()] = (Integer)params.get(PARAM_STATE);
        te.m_6596_();
        te.checkRedstone(te.f_58857_, te.f_58858_);
    });
    private static final Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/logic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(ThreeLogicTileEntity::new));
    }

    public ThreeLogicTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.TYPE_LOGIC.get(), pos, state);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getState(int index) {
        return this.logicTable[index];
    }

    public void checkRedstone() {
        int s = this.logicTable[this.powerLevel];
        if (s == -1) {
            return;
        }
        this.support.setRedstoneState((GenericTileEntity)this, s == 1 ? 15 : 0);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        for (int i = 0; i < 8; ++i) {
            this.logicTable[i] = info.m_128451_("state" + i);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        for (int i = 0; i < 8; ++i) {
            info.m_128405_("state" + i, this.logicTable[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = LogicSupport.getFacing((BlockState)state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction leftSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction rightSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                int powered1 = this.support.getInputStrength(world, pos, leftSide) > 0 ? 1 : 0;
                int powered2 = this.support.getInputStrength(world, pos, inputSide) > 0 ? 2 : 0;
                int powered3 = this.support.getInputStrength(world, pos, rightSide) > 0 ? 4 : 0;
                this.setPowerInput(powered1 + powered2 + powered3);
                this.checkRedstone();
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }
}

